
import os
import re

import numpy as np
import pandas as pd
import geopandas as gpd


def is_null_like_string(val):
    
    null_strings = ['n/a', '<na>', 'null', 'nan', 'none']
    return isinstance(val, str) and val.strip().lower() in null_strings


def is_real_null(val):
    
    return pd.isna(val) or is_null_like_string(val)


def is_empty_value(val):
    
    return isinstance(val, str) and bool(re.fullmatch(r'^\s*$', val))


def normalize_null_values(gdf):
    

    def convert_to_na(val):
        if is_real_null(val) or is_empty_value(val):
            return pd.NA
        return val

    return gdf.applymap(convert_to_na)
