from PyQt5.QtGui import QFontDatabase


def create_tab_style(total_width):
    tab_width = (total_width - 64) // 2
    return f"""
    QTabBar::tab {{
        width: {tab_width}px;
    }}
    """


font_ids = [
    QFontDatabase.addApplicationFont(":/plugins/urbanq/font/SpoqaHanSansNeo-Thin.ttf"),
    QFontDatabase.addApplicationFont(":/plugins/urbanq/font/SpoqaHanSansNeo-Light.ttf"),
    QFontDatabase.addApplicationFont(":/plugins/urbanq/font/SpoqaHanSansNeo-Regular.ttf"),
    QFontDatabase.addApplicationFont(":/plugins/urbanq/font/SpoqaHanSansNeo-Medium.ttf"),
    QFontDatabase.addApplicationFont(":/plugins/urbanq/font/SpoqaHanSansNeo-Bold.ttf")
]

font_qss = """
        /* 기본 Spoqa Han Sans Neo Regular 폰트 적용 */
        QWidget {
            font-family: 'Spoqa Han Sans Neo';
            font-weight: normal; /* Regular 기본 폰트 */
        }

        /* 얇은 텍스트 (Spoqa Han Sans Neo Thin 적용) */
        .thinText {
            font-family: 'Spoqa Han Sans Neo Thin';
            font-weight: normal;
        }

        /* 라이트 텍스트 (Spoqa Han Sans Neo Light 적용) */
        .lightText {
            font-family: 'Spoqa Han Sans Neo Light';
            font-weight: normal;
        }

        /* 중간 굵기 텍스트 (Spoqa Han Sans Neo Medium 적용) */
        .mediumText {
            font-family: 'Spoqa Han Sans Neo Medium';
            font-weight: normal;
        }

        /* 굵은 텍스트 (Spoqa Han Sans Neo Bold 적용) */
        .boldText {
            font-family: 'Spoqa Han Sans Neo Bold';
            font-weight: normal;
        }
    """

qLabel_style = """
    QLabel {
        background-color: qlineargradient(
            x1: 0, y1: 0, x2: 1, y2: 1,
            stop: 0 #673ab7,  /* 딥 퍼플 (보라+파랑 중간) */
            stop: 1 #3949ab   /* 선명한 인디고 블루 */
        );
    }
"""

selected_button_style = """
        background-color: #03316E;
        border-left: 4px solid #07ACCD;
        color: white;
    """

default_button_style = """
        background-color: none;
        border-left: none;
        color: #8EDBFF;
    """

gradient_style = """
    background-color: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 1, stop: 0 #0d6cb1, stop: 1 #153263); 
    color: white;
"""
default_style = """
    background-color: #5c5d5d;
    color: white;
"""




