import re


def validate_input(input_text, input_type):
    
    patterns = {
        "email": r"^[a-zA-Z0-9_.+-]+@[a-zA-Z0-9-]+\.[a-zA-Z0-9-.]+$",
        "key": r"^([A-Za-z0-9]+-){4}[A-Za-z0-9]+$",
    }

    pattern = patterns.get(input_type)
    if not pattern:
        raise ValueError(f"Unknown input_type: {input_type}")

    return bool(re.match(pattern, input_text))
