
import logging
from pathlib import Path


CURRENT_DIR = Path(__file__).resolve().parent
LOGGER_PATH = CURRENT_DIR / "error_log.txt"


LOGGER_PATH.parent.mkdir(parents=True, exist_ok=True)


if not logging.getLogger().hasHandlers():  
    logging.basicConfig(
        filename=LOGGER_PATH,                 
        level=logging.ERROR,                  
        format='%(asctime)s - %(levelname)s - %(message)s'  
    )


logger = logging.getLogger(__name__)
