
import os


from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QApplication, QDialog, QWidget, QMessageBox, QToolTip
from qgis.PyQt import QtWidgets, uic


import common
from urbanq.logging.logging_config import logger


from urbanq.menu.dataConversion.DataCleaning.DataCleaning_dockwidget import DataCleaningDockWidget
from urbanq.menu.dataConversion.DataManagement.DataManagement_dockwidget import DataManagementDockWidget
from urbanq.menu.dataConversion.DataQualityCheck.DataQualityCheck_dockwidget import DataQualityCheckDockWidget
from urbanq.menu.dataConversion.NumericDataProcessing.NumericDataProcessing_dockwidget import NumericDataProcessingDockWidget
from urbanq.menu.dataConversion.StringDataProcessing.StringDataProcessing_dockwidget import StringDataProcessingDockWidget
from urbanq.menu.dataConversion.AttributeFieldManagement.AttributeFieldManagement_dockwidget import AttributeFieldManagementDockWidget
from urbanq.menu.dataConversion.DataAggregationAndFiltering.DataAggregationAndFiltering_dockwidget import DataAggregationAndFilteringDockWidget



FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'mapVisualization_dockwidget_base.ui'))


class mapVisualizationDockWidget(QDialog, FORM_CLASS):  
    def __init__(self, parent=None):
        
        super(mapVisualizationDockWidget, self).__init__(parent)  
        
        
        
        
        
        self.setupUi(self)

        self.DataQualityCheck_label.setProperty("class", "boldText")
        self.DataAggregationAndFiltering_label.setProperty("class", "boldText")
        self.DataCleaning_label.setProperty("class", "boldText")
        self.DataManagement_label.setProperty("class", "boldText")
        self.NumericDataProcessing_label.setProperty("class", "boldText")
        self.StringDataProcessing_label.setProperty("class", "boldText")
        self.AttributeFieldManagement_label.setProperty("class", "boldText")

        
        self.QListWidgetList = [self.DataQualityCheck_list,
                                self.DataAggregationAndFiltering_list,
                                self.DataCleaning_list,
                                self.DataManagement_list,
                                self.NumericDataProcessing_list,
                                self.StringDataProcessing_list,
                                self.AttributeFieldManagement_list]
        
        
        self.pages_and_files = [
            (self.DataCleaning_list, DataCleaningDockWidget),
            (self.DataManagement_list, DataManagementDockWidget),
            (self.DataQualityCheck_list, DataQualityCheckDockWidget),
            (self.NumericDataProcessing_list, NumericDataProcessingDockWidget),
            (self.StringDataProcessing_list, StringDataProcessingDockWidget),
            (self.AttributeFieldManagement_list, AttributeFieldManagementDockWidget),
            (self.DataAggregationAndFiltering_list, DataAggregationAndFilteringDockWidget)
        ]

        
        self.connect_list_widget_signals()

    def adjust_list_widget_height(self, list_widget_list):
        
        try:
            for list_widget in list_widget_list:

                
                list_widget.setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
                list_widget.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
                list_widget.wheelEvent = lambda event: None  
                list_widget.setAutoScroll(False)  

                
                row_count = list_widget.count()
                if row_count > 0:
                    item_height = list_widget.sizeHintForRow(0)  
                    total_height = item_height * row_count + 7
                    list_widget.setFixedHeight(total_height)

                
                list_widget.setMouseTracking(True)
                list_widget.itemEntered.connect(lambda item: QToolTip.showText(self.cursor().pos(), item.toolTip(), self))

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

    def connect_list_widget_signals(self):
        
        try:
            for list_widget, widget_class in self.pages_and_files:
                list_widget.itemDoubleClicked.connect(
                    lambda item, widget_class=widget_class: self.open_dock_widget(item, widget_class))

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

    def open_dock_widget(self, item, widget_class):
        
        try:
            
            if not item.text().strip():
                return

            
            common.job_info["job_index"] = self.sender().row(item)
            common.job_info["job_title"] = item.text()
            common.job_info["job_tooltip"] = item.toolTip()
            common.job_info["job_class"] = widget_class.__name__

            
            dock_widget_ui = widget_class(self)  

            
            page_1_layout = self.parent().parent().findChild(QWidget, "page_dataConversion").layout()
            if page_1_layout:
                
                for i in reversed(range(page_1_layout.count())):
                    widget = page_1_layout.itemAt(i).widget()
                    if widget:
                        widget.deleteLater()
                page_1_layout.addWidget(dock_widget_ui)

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

