
import os


from PyQt5.QtCore import Qt
from PyQt5.QtWidgets import QApplication, QDialog, QWidget, QMessageBox, QToolTip
from qgis.PyQt import QtWidgets, uic


import common
from urbanq.logging.logging_config import logger


from urbanq.menu.spatialAnalysis.AddressConversion.AddressEditing_dockwidget import AddressEditingDockWidget
from urbanq.menu.spatialAnalysis.AddressConversion.AddressConversion_dockwidget import AddressConversionDockWidget
from urbanq.menu.spatialAnalysis.DistanceAnalysis.DistanceAnalysis_dockwidget import DistanceAnalysisDockWidget
from urbanq.menu.spatialAnalysis.DistanceAnalysis.DistanceCalculation_dockwidget import DistanceCalculationDockWidget
from urbanq.menu.spatialAnalysis.GeometryEditing.GeometryEditing_dockwidget import GeometryEditingDockWidget
from urbanq.menu.spatialAnalysis.GeometryValidation.GeometryValidation_dockwidget import GeometryValidationDockWidget



FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'spatialAnalysis_dockwidget_base.ui'))


class spatialAnalysisDockWidget(QDialog, FORM_CLASS):  
    def __init__(self, parent=None):
        
        super(spatialAnalysisDockWidget, self).__init__(parent)  
        
        
        
        
        
        self.setupUi(self)

        self.AddressConversion_label.setProperty("class", "boldText")
        self.GeometryValidation_label.setProperty("class", "boldText")
        self.GeometryEditing_label.setProperty("class", "boldText")
        self.DistanceAnalysi_label.setProperty("class", "boldText")

        
        self.QListWidgetList = [self.AddressConversion_list,
                                self.GeometryValidation_list,
                                self.GeometryEditing_list,
                                self.DistanceAnalysis_list]
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        self.pages_and_files = [
            (self.GeometryEditing_list, GeometryEditingDockWidget, None, None),
            (self.DistanceAnalysis_list, DistanceAnalysisDockWidget, DistanceCalculationDockWidget, 2),
            (self.AddressConversion_list, AddressEditingDockWidget, AddressConversionDockWidget, 1),
            (self.GeometryValidation_list, GeometryValidationDockWidget, None, None)
        ]

        
        self.connect_list_widget_signals()

    def adjust_list_widget_height(self, list_widget_list):
        
        try:
            for list_widget in list_widget_list:

                
                list_widget.setVerticalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
                list_widget.setHorizontalScrollBarPolicy(Qt.ScrollBarAlwaysOff)
                list_widget.wheelEvent = lambda event: None  
                list_widget.setAutoScroll(False)  

                
                row_count = list_widget.count()
                if row_count > 0:
                    item_height = list_widget.sizeHintForRow(0)  
                    total_height = item_height * row_count + 7
                    list_widget.setFixedHeight(total_height)

                
                list_widget.setMouseTracking(True)
                list_widget.itemEntered.connect(lambda item: QToolTip.showText(self.cursor().pos(), item.toolTip(), self))

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

    def connect_list_widget_signals(self):
        
        try:
            for list_widget, widget_class_1, widget_class_2, skip_index in self.pages_and_files:
                def make_handler(w1, w2, lw, idx):
                    return lambda item: self.open_dock_widget(
                        item,
                        w2 if (idx is not None and lw.row(item) > idx and w2 is not None) else w1
                    )

                list_widget.itemDoubleClicked.connect(
                    make_handler(widget_class_1, widget_class_2, list_widget, skip_index)
                )

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

    def open_dock_widget(self, item, widget_class):
        
        try:
            
            if not item.text().strip():
                return

            
            common.job_info["job_index"] = self.sender().row(item)
            common.job_info["job_title"] = item.text()
            common.job_info["job_tooltip"] = item.toolTip()
            common.job_info["job_class"] = widget_class.__name__

            
            dock_widget_ui = widget_class(self)  

            
            page_1_layout = self.parent().parent().findChild(QWidget, "page_spatialAnalysis").layout()
            if page_1_layout:
                
                for i in reversed(range(page_1_layout.count())):
                    widget = page_1_layout.itemAt(i).widget()
                    if widget:
                        widget.deleteLater()
                page_1_layout.addWidget(dock_widget_ui)

        except Exception as e:
            logger.error("에러 발생: %s", e, exc_info=True)

