

import sys
import os.path

from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication


plugin_dir = os.path.dirname(__file__)


sys.path.append(plugin_dir)  


import resources_rc


from urbanq.menu.license.loopinator import gm
from urbanq.logging.logging_config import logger
from urbanq.function.execute import execute_code_and_get_result


from urbanq.urbanq_dialog import UrbanQDialog
from urbanq.function.security.status import shimmer_blink, sparkle_shine
from urbanq.function.security.utils import spaghetti_code, flapdoodle_magic

class UrbanQ:
    

    def __init__(self, iface):
        
        
        self.iface = iface
        
        self.plugin_dir = os.path.dirname(__file__)
        
        locale = QSettings().value('locale/userLocale')[0:2]
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'UrbanQ_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        
        self.actions = []
        self.menu = self.tr(u'&UrbanQ - 공간데이터분석시스템')

        
        
        self.first_start = None

    
    def tr(self, message):
        
        
        return QCoreApplication.translate('UrbanQ', message)


    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        

        icon_path = ':/plugins/urbanq/image/logo.png'
        self.add_action(
            icon_path,
            text=self.tr(u'UrbanQ - 공간데이터분석시스템'),
            callback=self.run,
            parent=self.iface.mainWindow())

        
        self.first_start = True


    def unload(self):
        
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&UrbanQ - 공간데이터분석시스템'),
                action)
            self.iface.removeToolBarIcon(action)


    def run(self):
        

        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        
        

        code_str = "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"
        exec_globals = {"self": self, "UrbanQDialog": UrbanQDialog, "spaghetti_code": spaghetti_code, "shimmer_blink": shimmer_blink, "flapdoodle_magic": flapdoodle_magic, "sparkle_shine": sparkle_shine, "logger": logger,"__import__": __import__}
        execute_code_and_get_result(gm(code_str), exec_globals, "result")